<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCamposPagamentoContasAPagar extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contas_a_pagar', function (Blueprint $table) {
            $table->decimal('valor_pago')->nullable();
            $table->date('data_pagamento')->nullable();
            $table->string('codigo_barras', 48)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contas_a_pagar', function (Blueprint $table) {
            $table->dropColumn('valor_pago');
            $table->dropColumn('data_pagamento');
            $table->dropColumn('codigo_barras');
        });
    }
}
