<?php

namespace App\Services;

use App\Events\ServidorReligado;
use App\Exceptions\ValidationException;
use App\Models\Servidor;
use Illuminate\Validation\ValidationException as ValidationValidationException;

class ReafiliaSindicatoService
{
    protected $servidor;

    public function __construct(Servidor $servidor)
    {
        $this->servidor = $servidor;
    }

    public function reafilia()
    {
        $this->valida();

        $matricula = $this->servidor->matriculas()->desligadaTemporariamente()->first();
        $matricula->data_desligamento = null;
        $matricula->motivo_desligamento = null;
        $matricula->tipo_desligamento = null;

        $this->servidor->matriculas()->save($matricula);

        event(new ServidorReligado($this->servidor, $matricula));

        return $matricula;
    }

    private function valida()
    {
        if ($this->servidor->eAssociado()) {
            throw new ValidationException('Servidor já está filiado ao sindicato');
        }

        $matriculaDesligadaTemporariamente = $this->servidor->matriculas()->desligadaTemporariamente()->first();

        if ($matriculaDesligadaTemporariamente == null) {
            throw new ValidationValidationException('Servidor não está desfiliado temporariamente');
        }
    }
}
