<?php

namespace App\Services;

use App\Enums\StatusAgendamentoAtendimentoEnum;
use App\Exceptions\AgendamentoNaoPodeSerCanceladoException;
use App\Models\AgendamentoAtendimento;
use App\Models\MotivoCancelamentoAgendamento;
use App\Notifications\AgendamentoCanceladoNotification;
use Carbon\Carbon;

class CancelaAgendamentoAtendimentoService
{
    protected $agendamento;
    protected $status;
    protected $motivo;
    protected $observacao;

    public function __construct(AgendamentoAtendimento $agendamento, MotivoCancelamentoAgendamento $motivo, $observacao)
    {
        $this->agendamento = $agendamento;
        $this->agendamento->motivoCancelamento()->associate($motivo);
        $this->agendamento->observacao_cancelamento = $observacao;
    }

    public function cancela()
    {
        if (! $this->agendamento->status->isAberto()) {
            throw new AgendamentoNaoPodeSerCanceladoException('Agendamento só pode ser cancelado quando está em aberto');
        }

        $this->agendamento->status = StatusAgendamentoAtendimentoEnum::desmarcou();
        $this->agendamento->save();
        if ($this->agendamento->agendavel->celularMalaDireta()) {
            // $this->agendamento->agendavel->notify(new AgendamentoCanceladoNotification($this->agendamento));
        }

        return $this->agendamento;
    }
}
