<?php

namespace App\Observers;

use App\Enums\EventoMovimentacaoServidorEnum;
use App\Models\MovimentacaoServidor;
use App\Models\Servidor;
use Illuminate\Support\Facades\Auth;

class ServidorObserver
{
    /**
     * Handle the servidor "created" event.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return void
     */
    public function created(Servidor $servidor)
    {
        $movimentacao = new MovimentacaoServidor();
        $movimentacao->evento = EventoMovimentacaoServidorEnum::inclusao()->getIndex();
        $movimentacao->descricao = 'Servidor incluído';
        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->payload = $servidor->toArray();

        $movimentacao->save();
    }

    /**
     * Handle the servidor "updated" event.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return void
     */
    public function updated(Servidor $servidor)
    {
        if ($servidor->isClean()) {
            return;
        }

        $alteracoes = collect($servidor->getChanges())->except([
            'updated_at', 'data_admissao_sindicato', 'motivo_filiacao',
            'data_desligamento_sindicato', 'motivo_desligamento_sindicato']);

        if ($alteracoes->isEmpty()) {
            return;
        }
        
        $movimentacao = new MovimentacaoServidor();

        $movimentacao->descricao = 'Servidor editado';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::edicao()->getIndex();
        
        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->payload = $alteracoes->toArray();
        $movimentacao->save();
    }

    /**
     * Handle the servidor "deleted" event.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return void
     */
    public function deleted(Servidor $servidor)
    {
        $movimentacao = new MovimentacaoServidor();
        $movimentacao->descricao = 'Servidor excluído';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::exclusao()->getIndex();
        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->save();
    }

    /**
     * Handle the servidor "restored" event.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return void
     */
    public function restored(Servidor $servidor)
    {
        $movimentacao = new MovimentacaoServidor();
        $movimentacao->descricao = 'Servidor restaurado';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::restauracao()->getIndex();
        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->save();
    }

    /**
     * Handle the servidor "force deleted" event.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return void
     */
    public function forceDeleted(Servidor $servidor)
    {
        //
    }
}
