<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ServicoAtendimento extends Model implements AuditableContract
{
    use Auditable;
    
    protected $table = 'servicos_atendimento';
    protected $guarded = ['id', 'created_at', 'updated_at', 'deleted_at'];

    public function agendamentos()
    {
        return $this->hasMany(AgendamentoAtendimento::class);
    }

    public function horariosTrabalho()
    {
        return $this->morphMany(HorarioTrabalho::class, 'trabalhavel');
    }

    public static function juridico()
    {
        return self::where('id', 1)->first();
    }
}
