<?php

namespace App\Models;

use App\Models\MotivoRegistroAtendimento;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class RegistroAtendimento extends Model
{
    protected $table = 'registros_atendimentos';
    public $fillable = ['atendimento', 'resolvido'];
    public $casts = ['resolvido' => 'boolean'];

    public function servidor()
    {
        return $this->belongsTo(Servidor::class);
    }

    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function motivo()
    {
        return $this->belongsTo(MotivoRegistroAtendimento::class);
    }

    public function scopeResolvidos($query, $resolvido = true)
    {
        return $query->where('resolvido', $resolvido);
    }

    public function getCreatedAtAttribute()
    {
        return Carbon::create($this->attributes['created_at']);
    }
}
