<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PlanoConta;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class PlanoContaController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $planos = PlanoConta::search(request('busca'))
                    ->paginate();

        return view('admin.planos-contas.index', ['planos' => $planos, 'busca' => request('busca')]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.planos-contas.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'nome' => 'required|max:100|unique:planos_contas,nome',
        ]);

        $plano = new PlanoConta($request->all());
        $plano->save();

        return redirect()
                ->route('admin.planos-contas.index')
                ->with('status', 'Plano de conta incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PlanoConta  $plano
     * @return \Illuminate\Http\Response
     */
    public function edit(PlanoConta $plano)
    {
        return view('admin.planos-contas.edit', ['plano' => $plano]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PlanoConta  $plano
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PlanoConta $plano)
    {
        $this->validate($request, [
            'nome' => ['required', 'max:100', Rule::unique('planos_contas')->ignore($plano)],
        ]);

        $plano->fill($request->all());
        $plano->save();

        return redirect()
            ->route('admin.planos-contas.index')
            ->with('status', 'Plano de conta editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PlanoConta  $plano
     * @return \Illuminate\Http\Response
     */
    public function destroy(PlanoConta $plano)
    {
        $plano->delete();

        return redirect()
            ->route('admin.planos-contas.index')
            ->with('status', 'Plano de conta excluído com sucesso!');
    }
}
