<?php

namespace App\Models;

use App\Enums\EventoMovimentacaoServidorEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class MovimentacaoServidor extends Model
{
    protected $table = 'movimentacoes_servidores';
    protected $casts = [
        'payload' => 'array'
    ];

    public function getPayloadAttribute()
    {
        $payload = collect(json_decode($this->attributes['payload']))
                    ->except('id', 'created_at', 'updated_at', 'deleted_at', 'nome_exibir');
        
        $mapeado = [];
        foreach ($payload as $key => $value) {
            if (! $value) {
                continue;
            }

            if (preg_match("/data_/i", $key)) {
                $mapeado[Servidor::FIELD_MAP[$key]] = Carbon::create($value)->format('d/m/Y H:i:s');
            } elseif ($key == 'imagem') {
                $mapeado[Servidor::FIELD_MAP[$key]] = '[caminho da imagem]';
            } else {
                $mapeado[Servidor::FIELD_MAP[$key]] = $value;
            }
        }

        return $mapeado;
    }

    public function getEventoAttribute()
    {
        return EventoMovimentacaoServidorEnum::make($this->attributes['evento']);
    }

    public function servidor()
    {
        return $this->belongsTo(Servidor::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function registro()
    {
        return $this->belongsTo(RegistroServidor::class);
    }
}
