<?php

namespace App\Models;

use App\Enums\NivelSalarialEnum;
use App\Enums\StatusMensalidadeNivelEnum;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class MensalidadeNivel extends Model
{
    protected $table = 'mensalidades_niveis';
    protected $guarded = [];

    public function nivelSalarial()
    {
        return $this->belongsTo(NivelSalarial::class);
    }
    
    public function setInicioVigenciaAttribute($inicio)
    {
        if ($inicio instanceof Carbon) {
            $this->attributes['inicio_vigencia'] = $inicio;
        } else {
            $this->attributes['inicio_vigencia'] = Carbon::createFromFormat('d/m/Y', $inicio);
        }
    }

    public function getInicioVigenciaAttribute()
    {
        return Carbon::make($this->attributes['inicio_vigencia']);
    }

    public function setTerminoVigenciaAttribute($termino = null)
    {
        if ($termino instanceof Carbon) {
            $this->attributes['termino_vigencia'] = $termino;
        } elseif ($termino) {
            $this->attributes['termino_vigencia'] = Carbon::createFromFormat('d/m/Y', $termino);
        } else {
            $this->attributes['termino_vigencia'] = null;
        }
    }

    public function getTerminoVigenciaAttribute()
    {
        if ($this->attributes['termino_vigencia']) {
            return Carbon::make($this->attributes['termino_vigencia']);
        }

        return null;
    }

    public function setValorAttribute($valor)
    {
        $this->attributes['valor'] = str_replace(',', '.', str_replace('.', '', $valor));
    }

    public static function vigente(NivelSalarial $nivel)
    {
        return self::where('nivel_salarial_id', $nivel->id)
            ->whereNull('termino_vigencia')
            ->first();
    }

    public static function anterior(NivelSalarial $nivel)
    {
        return self::where('nivel_salarial_id', $nivel->id)
                   ->whereNotNull('termino_vigencia')
                   ->latest()
                   ->first();
    }

    public function scopeComStatus($query, StatusMensalidadeNivelEnum $status)
    {
        if ($status->isVigentes()) {
            return $query->whereNull('termino_vigencia');
        } elseif ($status->isAnteriores()) {
            return $query->whereNotNull('termino_vigencia');
        }

        return $query;
    }
}
