<?php

namespace App\Models;

use App\Enums\FiltroEnvioMensagemSMSEnum;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class MalaDireta extends Model implements AuditableContract
{
    use Auditable;

    protected $table = 'malas_diretas';
    protected $appends = ['enviado_por'];

    public function getFiltroServidorAttribute()
    {
        return FiltroEnvioMensagemSMSEnum::make($this->attributes['filtro_servidor']);
    }

    public function getEnviadoPorAttribute()
    {
        $idUsuario = $this->audits()->first()->user_id;
        return User::find($idUsuario);
    }
}
