<?php

namespace App\Models;

use Carbon\Carbon;
use Spatie\GoogleCalendar\Event;

class GoogleCalendarEvent extends Event
{
    public function formatToView()
    {
        $inicio = Carbon::make($this->googleEvent->start->dateTime);
        $fim = Carbon::make($this->googleEvent->end->dateTime);

        $this->googleEvent->titulo = $this->googleEvent->summary;
        $this->googleEvent->descricao = $this->googleEvent->description;
        $this->googleEvent->local = $this->googleEvent->location;
        $this->googleEvent->data = $inicio->format('d/m/Y H:i').' - '.$fim->format('d/m/Y H:i');
        $this->googleEvent->convidados = collect($this->attendees)->pluck('email')->toArray();

        return $this->googleEvent;
    }
}
