<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EspecialidadeConvenio extends Model
{
    protected $table = 'especialidades_convenios';
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function scopeBuscaPorTermo($query, $termo = '')
    {
        if ($termo) {
            $query->where('nome', 'ilike', "%{$termo}%");
        }

        return $query->orderBy('nome');
    }
}
