<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Endereco extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function enderecavel()
    {
        return $this->morphTo();
    }

    public function setCepAttribute($cep)
    {
        $this->attributes['cep'] = str_replace(['-'], '', $cep);
    }

    public function extenso()
    {
        $numero = $this->numero ? $this->numero : 'S/N';
        return "{$this->logradouro}, {$numero}. {$this->bairro}, {$this->cidade} - {$this->estado}. CEP {$this->cep}. {$this->complemento}";
    }

    public function getCepAttribute()
    {
        if (isset($this->attributes['cep'])) {
            return preg_replace('/(\d{5})(\d{3})/', '$1-$2', $this->attributes['cep']);
        }

        return null;
    }

    public function setEstadoAttribute($estado)
    {
        $this->attributes['estado'] = strtoupper($estado);
    }
}
