<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class DocumentoAssociado extends Model
{
    protected $table = 'documentos_associados';

    public function tipo()
    {
        return $this->belongsTo(TipoDocumento::class, 'tipo_documento_id');
    }

    public function associado()
    {
        $this->belongsTo(Servidor::class, 'servidor_id');
    }

    public function eImagem()
    {
        $extensoesImagem = ['jpg', 'jpeg', 'png', 'gif'];
        $extensao = File::extension($this->caminho);
        return in_array($extensao, $extensoesImagem);
    }
}
