<?php

namespace App\Models;

use App\Enums\CategoriaConfiguracaoEnum;
use App\Exceptions\ConfiguracaoNaoEncontradaException;
use Illuminate\Database\Eloquent\Model;

class Configuracao extends Model
{
    protected $table = 'configuracoes';
    protected $guarded = ['categoria'];

    public function setCategoriaAttribute(CategoriaConfiguracaoEnum $categoria)
    {
        $this->attributes['categoria'] = $categoria->getName();
    }

    public function getCategoriaAttribute()
    {
        return CategoriaConfiguracaoEnum::make($this->attributes['categoria']);
    }

    public static function get(string $nome, CategoriaConfiguracaoEnum $categoria)
    {
        $configuracao = self::where('nome', $nome)->where('categoria', $categoria->getName())->first();

        if (!$configuracao) {
            throw new ConfiguracaoNaoEncontradaException($nome, $categoria);
        }

        return  $configuracao->valor;
    }
}
