<?php

namespace App\Models;

use App\Enums\NivelSalarialEnum;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class Cargo extends Model implements AuditableContract
{
    use Auditable;
    
    protected $guarded = ['nivel_salarial'];

    public function registrosServidores()
    {
        return $this->hasMany(RegistroServidor::class);
    }

    public function nivelSalarial()
    {
        return $this->belongsTo(NivelSalarial::class);
    }
    
    public static function search($busca = '')
    {
        $result = self::query();

        if ($busca) {
            return $result->where(function ($query) use ($busca) {
                $query->where('nome', 'ilike', "%{$busca}%")
                    ->orderBy('nome', 'asc');
            });
        }

        return $result
            ->orderBy('nome', 'asc');
    }
}
