<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AtendimentoOdontologico extends Model
{
    protected $table = 'atendimentos_odontologicos';
    protected $fillable = ['tratamento_executado', 'prestador_servico_id'];

    public function agendamento()
    {
        return $this->belongsTo(AgendamentoAtendimento::class, 'agendamento_atendimento_id');
    }

    public function prestadorServico()
    {
        return $this->belongsTo(PrestadorServico::class, 'prestador_servico_id');
    }

    public function scopeDoPrestador($query, PrestadorServico $prestador)
    {
        return $query->where('prestador_servico_id', $prestador->id);
    }

    public function scopeBuscaPorTermo($query, $termo)
    {
        return $query->when($termo, function ($query) use ($termo) {
            $query->whereHas('agendamento', function ($query) use ($termo) {
                return $query->buscaPorTermo($termo);
            });
        });
    }
}
