<?php

namespace App\Listeners;

use App\Enums\MotivoExclusaoConvenioEnum;
use App\Events\ServidorReligadoExtraordinariamente;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class RestauraConvenios
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(ServidorReligadoExtraordinariamente $event)
    {
        $servidor = $event->servidor;

        DB::beginTransaction();
        
        $conveniosExcluidos = $servidor->convenios()->withTrashed()
                              ->motivoExclusaoDesfiliacao();
        $conveniosExcluidos->restore();
        $conveniosExcluidos->update(['motivo_exclusao' => null]);

        $dependentes = $servidor->dependentes;
        $dependentes->each(function ($dependente) {
            $conveniosExcluidosDependente = $dependente->convenios()->withTrashed()
                                                                    ->motivoExclusaoDesfiliacao();
            $conveniosExcluidosDependente->restore();
            $conveniosExcluidosDependente->update(['motivo_exclusao' => null]);
        });

        DB::commit();

        Log::info("Convênios do servidor '$servidor->nome' e de seus dependentes foram restaurados", [
            'servidor' => $servidor,
            'dependentes' => $dependentes,
        ]);
    }
}
