<?php

namespace App\Listeners;

use App\Enums\MotivoExclusaoConvenioEnum;
use App\Events\ServidorDesfiliadoDefinitivamente;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class RemoveConvenios
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(ServidorDesfiliadoDefinitivamente $event)
    {
        $servidor = $event->servidor;

        DB::beginTransaction();
        
        $servidor->convenios()->update(['motivo_exclusao' => MotivoExclusaoConvenioEnum::desfiliacaoDefinitiva()->getIndex()]);
        $servidor->convenios()->delete();
        $servidor->dependentes->each(function ($dependente) {
            $dependente->convenios()->update(['motivo_exclusao' => MotivoExclusaoConvenioEnum::desfiliacaoDefinitiva()->getIndex()]);
            $dependente->convenios()->delete();
        });

        DB::commit();

        Log::info("Convênios do servidor '$servidor->nome' e de seus dependentes foram removidos", [
            'servidor' => $servidor
        ]);
    }
}
