<?php

namespace App\Listeners;

use App\Enums\EventoMovimentacaoServidorEnum;
use App\Models\MovimentacaoServidor;
use Illuminate\Support\Facades\Auth;

class IncluiMovimentacaoServidorReligadoExtraordinariamente
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $servidor = $event->servidor;
        $matricula = $event->matricula;

        $movimentacao = new MovimentacaoServidor();

        $movimentacao->descricao = 'Servidor religado extraordinariamente';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::religamentoExtraordinario()->getIndex();

        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->payload = [
            'motivo_religamento_extraordinario' => $matricula->motivo_religamento_extraordinario,
            'data_religamento_extraordinario' => $matricula->data_religamento_extraordinario,
        ];
        $movimentacao->save();
    }
}
