<?php

namespace App\Listeners;

use App\Enums\EventoMovimentacaoServidorEnum;
use App\Events\ServidorReligado;
use App\Models\MovimentacaoServidor;
use Illuminate\Support\Facades\Auth;

class IncluiMovimentacaoServidorReligado
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(ServidorReligado $event)
    {
        $servidor = $event->servidor;

        $movimentacao = new MovimentacaoServidor();

        $movimentacao->descricao = 'Servidor religado';
        $movimentacao->evento = EventoMovimentacaoServidorEnum::religamento()->getIndex();

        $movimentacao->servidor()->associate($servidor);
        $movimentacao->user()->associate(Auth::user());
        $movimentacao->save();
    }
}
