<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UnidadeOrganizacionalUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'cep' => str_replace(['.', '-'], '', $this->cep)
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => ['required', 'max:100', Rule::unique('unidades_organizacionais', 'nome')->ignore($this->unidade)],
            'sigla' => 'nullable|max:15',
            'centro_custo' => 'nullable|max:11',
            'cep' => 'nullable|numeric',
            'logradouro' => 'required_with:cep|max:150',
            'bairro' => 'required_with:cep|max:50',
            'cidade' => 'required_with:cep|max:100',
            'numero' => 'required_with:cep|nullable|numeric',
            'estado' => 'required_with:cep|max:2',
            'observacoes_endereco' => 'nullable|max:100',
        ];
    }

    public function attributes()
    {
        return [
            'cep' => 'CEP',
            'numero' => 'número',
            'observacoes_endereco' => 'observações do endereço'
        ];
    }
}
