<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UnidadeOrganizacionalTransferirRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->unidadeDestino) {
                $hierarquiaUnidadeDestino = explode('/', $this->unidadeDestino->hierarquia);

                if (in_array($this->unidadeTransferir->id, $hierarquiaUnidadeDestino)) {
                    $validator->errors()->add('', 'Não é possível transferir uma unidade para uma outra pertencente à sua hierarquia');
                }
            }
        });
    }
}
