<?php

namespace App\Http\Requests;

use App\Rules\CPFRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ServidorUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'cpf' => str_replace(['.', '-'], '', $this->cpf)
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|max:150',
            'nome_social' => 'nullable|max:150',
            'cpf' => ['required', 'max:14', new CPFRule, Rule::unique('servidores')->ignore($this->servidor)],
            'rg' => 'nullable|max:15',
            'data_nascimento' => 'nullable|date_format:d/m/Y',
            'nome_pai' => 'nullable|max:150',
            'nome_mae' => 'nullable|max:150',
            'nome_mae' => 'nullable|max:150',
            'naturalidade' => 'nullable|max:150',
            'naturalidade_uf' => 'nullable|required_with:naturalidade|max:2',
            'nacionalidade' => 'nullable|max:150',
            'nivel_ensino' => 'nullable|numeric',
            'observacoes' => 'nullable|max:150',
            'estado_civil' => 'nullable',
            'sexo' => 'nullable',

            'telefone.*.numero' => 'nullable|regex:/^\(\d{2}\) \d{4,5}-\d{4}$/',
            'telefone.0.numero' => 'required',
            'email.*.endereco' => 'nullable|email',
        ];
    }

    public function attributes()
    {
        return [
            'cpf' => 'CPF',
            'rg' => 'RG',
            'cep' => 'CEP',
            'nome_mae' => 'nome da mãe',
            'nome_pai' => 'nome do pai',
            'observacoes' => 'observações',
            'naturalidade_uf' => 'Naturalidade/UF',
            'email.*.endereco' => 'e-mail',
        ];
    }

    public function messages()
    {
        return [
            'data_admissao_sindicato.before_or_equal' => 'O campo data adm. sindicato deve ser uma data anterior ou igual a hoje.',
            'email.*.endereco.email' => 'O endereço de e-mail fornecido deve ser válido',
            'telefone.0.numero.required' => 'Um servidor deve ter pelo menos um telefone cadastrado',
            'telefone.*.numero.regex' => 'O telefone informado deve estar em um formato válido',
            'naturalidade_uf.required_with' => 'O campo Naturalidade/UF deve ser informado junto com a naturalidade',
        ];
    }
}
