<?php

namespace App\Http\Requests;

use App\Models\MensalidadeNivel;
use App\Models\NivelSalarial;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class MensalidadeNivelUpdateRequest extends FormRequest
{
    protected function prepareForValidation()
    {
        $nivel = $this->mensalidade->nivelSalarial;
        $mensalidadeAnterior = MensalidadeNivel::anterior($nivel);

        $this->merge([
            'nivelSalarial' => $nivel,
            'mensalidadeAnterior' => $mensalidadeAnterior,
        ]);
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->inicioNaVigenciaMensalidadeAnterior()) {
                $validator->errors()->add('inicio_vigencia', 'Vigência deve ser após o inicio da vigência da mensalidade anterior para este nível');
            }
        });
    }

    private function inicioNaVigenciaMensalidadeAnterior()
    {
        $inicioVigencia = Carbon::createFromFormat('d/m/Y', $this->inicio_vigencia);

        if ($this->mensalidadeAnterior) {
            $inicioVigenciaAnterior = $this->mensalidadeAnterior->inicio_vigencia;
            $terminoVigenciaAnterior = $this->mensalidadeAnterior->terminoVigencia;
            
            if ($inicioVigencia->between($inicioVigenciaAnterior, $terminoVigenciaAnterior)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'valor' => 'required',
            'inicio_vigencia' => 'required|date_format:d/m/Y',
        ];
    }
}
