<?php

namespace App\Http\Requests;

use App\Models\MensalidadeNivel;
use App\Models\NivelSalarial;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class MensalidadeNivelStoreRequest extends FormRequest
{
    protected function prepareForValidation()
    {
        $nivel = NivelSalarial::find($this->nivel_salarial_id);
        $mensalidadeVigente = MensalidadeNivel::vigente($nivel);

        $this->merge([
            'nivelSalarial' => $nivel,
            'mensalidadeVigente' => $mensalidadeVigente,
        ]);
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->inicioAnteriorOuIgualAMensalidadeVigente()) {
                $validator->errors()->add('inicio_vigencia', 'Vigência deve ser após o inicio da vigência da mensalidade atual para este nível');
            }
        });
    }

    private function inicioAnteriorOuIgualAMensalidadeVigente()
    {
        $inicioVigencia = Carbon::createFromFormat('d/m/Y', $this->inicio_vigencia);
        if ($this->mensalidadeVigente && $inicioVigencia <= $this->mensalidadeVigente->inicio_vigencia) {
            return true;
        }

        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nivel_salarial_id' => 'required',
            'valor' => 'required',
            'inicio_vigencia' => 'required|date_format:d/m/Y',
        ];
    }
}
