<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EnderecoUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'cep' => str_replace('-', '', $this->cep)
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'cep' => 'numeric',
            'logradouro' => 'required|max:150',
            'bairro' => 'required|max:50',
            'cidade' => 'required|max:100',
            'numero' => 'numeric|required',
            'estado' => 'required|max:2',
            'complemento' => 'nullable|max:50',
            'observacoes_endereco' => 'max:100',
        ];
    }
}
