<?php

namespace App\Http\Requests;

use App\Enums\TipoDesligamentoSindicatoEnum;
use Illuminate\Foundation\Http\FormRequest;

class DesfiliaServidorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'data_desligamento' => 'required|date_format:d/m/Y',
            'mes_ano_parou_desconto' => 'nullable:tipo_desligamento:1|date_format:m/Y'
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->servidor->desfiliadoDefinitivamente()) {
                $validator->errors()->add('tipo_desligamento', 'Servidor já está desfiliado');
            } else if ($this->servidor->desfiliadoTemporariamente() && !$this->motivo_desligamento_definitivo) {
                $validator->errors()->add('motivo_desligamento_definitivo', 'O campo Motivo é obrigatório');
            } else if ($this->tipo_desligamento == TipoDesligamentoSindicatoEnum::definitivo()->getIndex() && !$this->motivo_desligamento_definitivo) {
                $validator->errors()->add('motivo_desligamento_definitivo', 'O campo Motivo é obrigatório');
            } else if ($this->tipo_desligamento == TipoDesligamentoSindicatoEnum::temporario()->getIndex() && !$this->motivo_desligamento_temporario) {
                $validator->errors()->add('motivo_desligamento_temporario', 'O campo Motivo é obrigatório');
            }
        });
    }

    public function messages()
    {
        return [
            'mes_ano_parou_desconto.date_format' => 'Campo Mês/ano que parou desconto está em um formato inválido',
        ];
    }
}
