<?php

namespace App\Http\Requests;

use App\Models\Configuracao;
use Illuminate\Foundation\Http\FormRequest;

class ConfiguracaoUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|max:100',
            'valor' => 'required|max:100'
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->existeConfiguracaoComMesmaCategoria()) {
                $validator->errors()->add('nome', 'Já existe uma configuração com mesmo nome e categoria');
            }
        });
    }

    public function existeConfiguracaoComMesmaCategoria()
    {
        return Configuracao::where('nome', $this->nome)
            ->where('categoria', $this->categoria)
            ->where('id', '!=', $this->configuracao->id)
            ->count() > 0;
    }
}
