<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClassificacaoContaStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|max:100',
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->jaExiste()) {
                $validator->errors()->add('nome', 'Plano de contas já possui uma classificação com esse nome');
            }
        });
    }

    private function jaExiste()
    {
        $jaExiste = $this->plano->classificacoes()->where('nome', $this->nome)->count() > 0;
        if ($jaExiste) {
            return true;
        }

        return false;
    }
}
