<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AtualizaFalecimentoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'cep' => str_replace(['.', '-'], '', $this->cep)
        ]);
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'cep' => 'nullable|numeric',
            'logradouro' => 'required_with:cep|max:150',
            'bairro' => 'required_with:cep|max:50',
            'cidade' => 'required_with:cep|max:100',
            'numero' => 'required_with:cep|nullable|numeric',
            'estado' => 'required_with:cep|max:2',
            'observacoes_endereco' => 'nullable|max:100',
            'nome_herdeiro' => 'nullable|max:150',
            'observacao_falecimento' => 'nullable|max:255',
            'data_falecimento' => 'nullable|date_format:d/m/Y|before_or_equal:today',
        ];
    }

    public function messages()
    {
        return [
            'data_falecimento.before' => "O campo Data de falecimento deve ser anterior ou igual à data atual",
        ];
    }
}
