<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class LogradouroAPIController extends Controller
{
    public function buscaCEP(Request $request)
    {
        $cep = str_replace('-', '', $request->cep);

        $resultado = DB::select("SELECT 
                                     log_logradouro.log_tipo_logradouro, 
                                     log_logradouro.log_no as logradouro,
                                     log_bairro.bai_no as bairro,
                                     log_localidade.loc_no as cidade,
                                     log_localidade.ufe_sg as uf,
                                     log_logradouro.cep
                                 FROM 
                                     log_logradouro, log_localidade, log_bairro
                                 WHERE 
                                     log_logradouro.loc_nu_sequencial = log_localidade.loc_nu_sequencial
                                 AND
                                     log_logradouro.bai_nu_sequencial_ini = log_bairro.bai_nu_sequencial
                                 AND 
                                     log_logradouro.cep = ?", [$cep]);
        return $resultado;
    }

    public function buscaLogradouro(Request $request)
    {
        $this->validate($request, [
            'logradouro' => 'required|string',
            'numero' => 'nullable|numeric',
        ]);

        $logradouro = "%$request->logradouro%";

        $sql = "SELECT
            log_logradouro.log_tipo_logradouro, 
            log_logradouro.log_no as logradouro,
            log_bairro.bai_no as bairro,
            log_localidade.loc_no as cidade,
            log_localidade.ufe_sg as uf,
            log_logradouro.cep
            FROM
                log_logradouro, log_localidade, log_bairro
            WHERE 
                log_logradouro.loc_nu_sequencial = log_localidade.loc_nu_sequencial
            AND
                log_logradouro.bai_nu_sequencial_ini = log_bairro.bai_nu_sequencial
            AND
                log_logradouro.LOG_NOME ILIKE :logradouro";
        
        $parametros = ['logradouro' => $logradouro];

        if ($request->numero) {
            $sql .= "AND log_logradouro.LOC_NU_SEQUENCIAL = :numero";
            $parametros['numero'] = $request->numero;
        }

        $resultado = DB::select($sql, $parametros);

        return $resultado;
    }
}
