<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TipoAcaoProcesso;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class TipoAcaoProcessoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tipos = TipoAcaoProcesso::orderBy('descricao')->get();

        return view('admin.tipos-acoes-processos.index', ['tipos' => $tipos]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.tipos-acoes-processos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'descricao' => 'required|max:50|unique:tipos_acoes_processos,descricao',
        ], [], ['descricao' => 'descrição']);

        $tipo = new TipoAcaoProcesso($request->all());
        $tipo->save();

        return redirect()
                ->route('admin.tipos-acoes-processos.index')
                ->with('status', 'Tipo de ação incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TipoAcaoProcesso  $tipo
     * @return \Illuminate\Http\Response
     */
    public function edit(TipoAcaoProcesso $tipo)
    {
        return view('admin.tipos-acoes-processos.edit', ['tipo' => $tipo]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TipoAcaoProcesso  $tipo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TipoAcaoProcesso $tipo)
    {
        $this->validate($request, [
            'descricao' => ['required', 'max:50', Rule::unique('tipos_acoes_processos')->ignore($tipo)],
        ], [], ['descricao' => 'descrição']);

        $tipo->fill($request->all());
        $tipo->save();

        return redirect()
            ->route('admin.tipos-acoes-processos.index')
            ->with('status', 'Tipo de ação editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TipoAcaoProcesso  $tipo
     * @return \Illuminate\Http\Response
     */
    public function destroy(TipoAcaoProcesso $tipo)
    {
        $tipo->delete();

        return redirect()
            ->route('admin.tipos-acoes-processos.index')
            ->with('status', 'Tipo de ação excluído com sucesso!');
    }
}
