<?php

namespace App\Http\Controllers\Admin\Servidor;

use App\Http\Controllers\Controller;
use App\Models\MovimentacaoServidor;
use App\Models\Servidor;

class MovimentacaoServidorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Servidor $servidor)
    {
        $movimentacoes = $servidor->movimentacoes()->orderBy('created_at', 'desc')->paginate();

        return view('admin.servidores.movimentacoes.index', [
            'servidor' => $servidor,
            'movimentacoes' => $movimentacoes,
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Servidor  $servidor
     * @return \Illuminate\Http\Response
     */
    public function show(Servidor $servidor, MovimentacaoServidor $movimentacao)
    {
        return view('admin.servidores.movimentacoes.show', [
            'servidor' => $servidor,
            'movimentacao' => $movimentacao,
        ]);
    }
}
