<?php

namespace App\Http\Controllers\Admin\Servidor;

use App\Http\Controllers\Controller;
use App\Http\Requests\EnderecoStoreRequest;
use App\Http\Requests\EnderecoUpdateRequest;
use App\Models\Endereco;
use App\Models\Logradouro\Estado;

;
use App\Models\Servidor;
use Illuminate\Http\Request;

class EnderecoServidorController extends Controller
{
    private function routes($servidor, $endereco = null)
    {
        return [
            'enderecavel' => [
                'key' => 'servidor',
                'index' => ['route' => 'admin.servidores.index'],
                'edit' =>  ['route' => 'admin.servidores.edit', 'params' => ['servidor' => $servidor]],
            ],
            'endereco' => [
                'create' => ['route' => 'admin.servidores.enderecos.create', 'params' => ['servidor' => $servidor]],
                'edit'   => ['route' => 'admin.servidores.enderecos.edit', 'params' => ['servidor' => $servidor]],
                'store'  => ['route' => 'admin.servidores.enderecos.store', 'params' => ['servidor' => $servidor]],
                'update'  => ['route' => 'admin.servidores.enderecos.update', 'params' => ['servidor' => $servidor, 'endereco' => $endereco]],
                'destroy'  => ['route' => 'admin.servidores.enderecos.destroy', 'params' => ['servidor' => $servidor]],
            ],
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Servidor $servidor)
    {
        $estados = Estado::orderBy('ufe_sg')->select('ufe_sg')->get();

        return view('admin.enderecos.create', [
            'servidor' => $servidor,
            'enderecavel' => 'Servidor',
            'routes' => $this->routes($servidor),
            'estados' => $estados
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(EnderecoStoreRequest $request, Servidor $servidor)
    {
        $endereco = new Endereco($request->except('observacoes_endereco', 'sem_numero'));
        $endereco->observacoes = $request->observacoes_endereco;
        $endereco->aceita_mala_direta = $request->boolean('aceita_mala_direta');
        $servidor->enderecos()->save($endereco);

        return redirect()
            ->route('admin.servidores.edit', ['servidor' => $servidor])
            ->with('status', 'Endereço incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Endereco  $endereco
     * @return \Illuminate\Http\Response
     */
    public function edit(Servidor $servidor, Endereco $endereco)
    {
        $estados = Estado::orderBy('ufe_sg')->select('ufe_sg')->get();

        return view('admin.enderecos.edit', [
            'servidor' => $servidor,
            'endereco' => $endereco,
            'enderecavel' => 'Servidor',
            'estados' => $estados,
            'routes' => $this->routes($servidor, $endereco)
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Endereco  $endereco
     * @return \Illuminate\Http\Response
     */
    public function update(EnderecoUpdateRequest $request, Servidor $servidor, Endereco $endereco)
    {
        $endereco->fill($request->except('observacoes_endereco', 'sem_numero'));
        $endereco->observacoes = $request->observacoes_endereco;
        $endereco->aceita_mala_direta = $request->boolean('aceita_mala_direta');
        $endereco->save();

        return redirect()
            ->route('admin.servidores.edit', ['servidor' => $servidor])
            ->with('status', 'Endereço editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Endereco  $endereco
     * @return \Illuminate\Http\Response
     */
    public function destroy(Servidor $servidor, Endereco $endereco)
    {
        $endereco->delete();

        return redirect()
            ->route('admin.servidores.edit', ['servidor' => $servidor])
            ->with('status', 'Endereço excluído com sucesso!');
    }
}
