<?php

namespace App\Http\Controllers\Admin\Servidor;

use App\Enums\MotivoExclusaoConvenioEnum;
use App\Http\Controllers\Controller;
use App\Models\Convenio;
use App\Models\ConvenioPessoa;
use App\Models\Servidor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ConvenioServidorController extends Controller
{
    public function index(Servidor $servidor)
    {
        return view('admin.servidores.convenios.index', [
            'servidor' => $servidor,
            'convenios' => $servidor->convenios
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Servidor $servidor)
    {
        $conveniosServidor = $servidor->convenios->pluck('convenio_id');
        $convenios = Convenio::whereNotIn('id', $conveniosServidor)->orderBy('nome')->get();

        return view('admin.servidores.convenios.create', [
            'servidor' => $servidor,
            'convenios' => $convenios
        ]);
    }

    public function store(Request $request, Servidor $servidor)
    {
        $convenio = new ConvenioPessoa($request->all());
        $servidor->convenios()->save($convenio);

        return redirect()
            ->route('admin.servidores.convenios.index', ['servidor' => $servidor])
            ->with('status', 'Convênio incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function edit(Servidor $servidor, ConvenioPessoa $convenio)
    {
        $conveniosServidor = $servidor->convenios->where('convenio_id', '!=', $convenio->convenio->id)->pluck('convenio_id');
        $convenios = Convenio::whereNotIn('id', $conveniosServidor)->orderBy('nome')->get();

        return view('admin.servidores.convenios.edit', [
            'servidor' => $servidor,
            'convenios' => $convenios,
            'convenio' => $convenio,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Servidor $servidor, ConvenioPessoa $convenio)
    {
        $convenio->fill($request->all());
        $convenio->save();

        return redirect()
            ->route('admin.servidores.convenios.index', ['servidor' => $servidor])
            ->with('status', 'Convênio editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function destroy(Servidor $servidor, ConvenioPessoa $convenio)
    {
        $rotaTermo = '';

        if ($convenio->convenio->eSeguro()) {
            $rotaTermo = route('admin.formularios.servidores.cancelamento-seguro', ['servidor' => $servidor]);
        } elseif ($convenio->convenio->eOsan()) {
            $rotaTermo = route('admin.formularios.servidores.cancelamento-seguro', ['servidor' => $servidor]);
        }

        DB::beginTransaction();
        $convenio->motivo_exclusao = MotivoExclusaoConvenioEnum::outro();
        $convenio->save();
        $convenio->delete();
        DB::commit();

        $convenio->delete();

        $redirect = redirect()
            ->route('admin.servidores.convenios.index', ['servidor' => $servidor])
            ->with('status', 'Convênio excluído com sucesso!');

        if ($rotaTermo) {
            $redirect->with('termos-assinar', true)
                     ->with('rota-termo', $rotaTermo);
        }

        return $redirect;
    }
}
