<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContaPagarReceber;
use Carbon\Carbon;
use Illuminate\Http\Request;

class MovimentoCaixaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->periodo) {
            $periodo = $this->periodo($request->periodo);
        } else {
            $ultimoMovimento = ContaPagarReceber::orderBy('data_pagamento', 'desc')->first();
            $inicio = optional($ultimoMovimento->data_pagamento)->setDay(1) ?? today()->setDay(1);
            $fim  = $inicio->copy()->addMonth();
            $periodo = [$inicio, $fim];
        }

        $movimentos = ContaPagarReceber::movimentos($periodo)->comNotaFiscal($request->nota_fiscal)->paginate();

        return view('admin.movimento-caixa.index', [
            'periodo' => $request->periodo,
            'notaFiscal' => $request->nota_fiscal,
            'movimentos' => $movimentos,
            'data_lancamento' => $request->data_lancamento,
            'saldo' => ContaPagarReceber::saldo($periodo),
        ]);
    }

    private function periodo(string $periodo)
    {
        $venc = collect(explode('-', $periodo));
        $inicio = Carbon::createFromFormat('d/m/Y', trim($venc[0]))->setTime(0, 0, 0);
        $fim = Carbon::createFromFormat('d/m/Y', trim($venc[1]))->setTime(23, 59);
        return [$inicio, $fim];
    }
}
