<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MotivoRegistroAtendimento;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class MotivoRegistroAtendimentoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $motivos = MotivoRegistroAtendimento::all();

        return view('admin.motivos-registros-atendimento.index', ['motivos' => $motivos]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.motivos-registros-atendimento.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'descricao' => 'required|max:100|unique:motivos_registro_atendimento,descricao',
        ]);

        $motivo = new MotivoRegistroAtendimento($request->all());
        $motivo->save();

        return redirect()
                ->route('admin.motivos-registros-atendimento.index')
                ->with('status', 'Motivo incluído com sucesso!');
    }

    public function edit(MotivoRegistroAtendimento $motivo) {
        return view('admin.motivos-registros-atendimento.edit', ['motivo' => $motivo]);
    }

    public function update(Request $request, MotivoRegistroAtendimento $motivo)
    {
        $this->validate($request, [
            'descricao' => ['required', 'max:100', Rule::unique('motivos_registro_atendimento')->ignore($motivo)],
        ]);

        $motivo->fill($request->all());
        $motivo->save();

        return redirect()
            ->route('admin.motivos-registros-atendimento.index')
            ->with('status', 'Motivo editado com sucesso!');
    }

    public function destroy(MotivoRegistroAtendimento $motivo)
    {
        $motivo->delete();

        return redirect()
            ->route('admin.motivos-registros-atendimento.index')
            ->with('status', 'Motivo excluído com sucesso!');
    }
}
