<?php

namespace App\Http\Controllers\Admin;

use App\Models\MotivoCancelamentoAgendamento;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MotivoCancelamentoAgendamentoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $motivos = MotivoCancelamentoAgendamento::orderBy('descricao')->get();

        return view('admin.motivos-cancelamentos-agendamentos.index', ['motivos' => $motivos]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.motivos-cancelamentos-agendamentos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $motivo = new MotivoCancelamentoAgendamento($request->all());
        $motivo->save();

        return redirect()
                ->route('admin.motivos-cancelamentos-agendamentos.index')
                ->with('status', 'Motivo incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\MotivoCancelamentoAgendamento  $motivo
     * @return \Illuminate\Http\Response
     */
    public function edit(MotivoCancelamentoAgendamento $motivo)
    {
        return view('admin.motivos-cancelamentos-agendamentos.edit', ['motivo' => $motivo]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\MotivoCancelamentoAgendamento  $motivo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MotivoCancelamentoAgendamento $motivo)
    {
        $motivo->fill($request->all());
        $motivo->save();

        return redirect()
            ->route('admin.motivos-cancelamentos-agendamentos.index')
            ->with('status', 'Motivo alterado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\MotivoCancelamentoAgendamento  $motivo
     * @return \Illuminate\Http\Response
     */
    public function destroy(MotivoCancelamentoAgendamento $motivo)
    {
        $motivo->delete();
        
        return redirect()->back()->with('status', 'Motivo excluído com sucesso!');
    }
}
