<?php

namespace App\Http\Controllers\Admin\Funcionario;

use App\Enums\GrauParentescoEnum;
use App\Enums\SexoEnum;
use App\Http\Controllers\Controller;
use App\Http\Requests\DependenteStoreRequest;
use App\Http\Requests\DependenteUpdateRequest;
use App\Models\Convenio;
use App\Models\Dependente;
use App\Models\Funcionario;

class DependenteFuncionarioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Funcionario $funcionario)
    {
        $dependentes = $funcionario->dependentes()->orderBy('nome')->get();

        return view('admin.dependentes.index', [
            'dependentes' => $dependentes,
            'dependido' => 'Funcionário',
            'routes' => $this->routes($funcionario),
        ]);
    }

    private function routes($funcionario, $dependente = null)
    {
        return [
            'dependido' => [
                'key' => 'funcionario',
                'index' => ['route' => 'admin.funcionarios.index'],
                'edit' =>  ['route' => 'admin.funcionarios.edit', 'params' => ['funcionario' => $funcionario]],
                'nome' => $funcionario->nome,
            ],
            'dependente' => [
                'index'  => ['route' => 'admin.funcionarios.dependentes.index', 'params' => ['funcionario' => $funcionario]],
                'create' => ['route' => 'admin.funcionarios.dependentes.create', 'params' => ['funcionario' => $funcionario]],
                'edit'   => ['route' => 'admin.funcionarios.dependentes.edit', 'params' => ['funcionario' => $funcionario]],
                'store'  => ['route' => 'admin.funcionarios.dependentes.store', 'params' => ['funcionario' => $funcionario]],
                'update'  => ['route' => 'admin.funcionarios.dependentes.update', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
                'destroy'  => ['route' => 'admin.funcionarios.dependentes.destroy', 'params' => ['funcionario' => $funcionario]],
            ],
            'convenio' => [
                'index'  => ['route' => 'admin.funcionarios.dependentes.convenios.index', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
                'create' => ['route' => 'admin.funcionarios.dependentes.convenios.create', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
                'edit'   => ['route' => 'admin.funcionarios.dependentes.convenios.edit', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
                'store'  => ['route' => 'admin.funcionarios.dependentes.convenios.store', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
                'update'  => ['route' => 'admin.funcionarios.dependentes.convenios.update', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente, 'dependente' => $dependente]],
                'destroy'  => ['route' => 'admin.funcionarios.dependentes.convenios.destroy', 'params' => ['funcionario' => $funcionario, 'dependente' => $dependente]],
            ],
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Funcionario $funcionario)
    {
        $graus = GrauParentescoEnum::getAll();
        $sexos = SexoEnum::getAll();
        $convenios = Convenio::all();
        return view('admin.dependentes.create', [
            'graus' => $graus,
            'sexos' => $sexos,
            'convenios' => $convenios,
            'dependido' => 'Funcionário',
            'routes' => $this->routes($funcionario)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(DependenteStoreRequest $request, Funcionario $funcionario)
    {
        $dependente = new Dependente($request->all());
        $dependente->grau_parentesco = GrauParentescoEnum::make((int) $request->grau_parentesco);
        $dependente->sexo = SexoEnum::make((int) $request->sexo);
        $funcionario->dependentes()->save($dependente);

        return redirect()
                ->route('admin.funcionarios.dependentes.index', ['funcionario' => $funcionario])
                ->with('status', 'Dependente incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function edit(Funcionario $funcionario, Dependente $dependente)
    {
        $graus = GrauParentescoEnum::getAll();
        $sexos = SexoEnum::getAll();
        $convenios = Convenio::all();
        return view('admin.dependentes.edit', [
            'graus' => $graus,
            'sexos' => $sexos,
            'convenios' => $convenios,
            'dependente' => $dependente,
            'dependido' => 'Funcionário',
            'routes' => $this->routes($funcionario, $dependente)
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function update(DependenteUpdateRequest $request, Funcionario $funcionario, Dependente $dependente)
    {
        $dependente->fill($request->all());
        $dependente->grau_parentesco = GrauParentescoEnum::make((int) $request->grau_parentesco);
        $dependente->sexo = SexoEnum::make((int) $request->sexo);
        $dependente->save();

        return redirect()
            ->route('admin.funcionarios.dependentes.index', ['funcionario' => $funcionario])
            ->with('status', 'Dependente editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Dependente  $dependente
     * @return \Illuminate\Http\Response
     */
    public function destroy(Funcionario $funcionario, Dependente $dependente)
    {
        $dependente->delete();

        return redirect()
            ->route('admin.funcionarios.dependentes.index', ['funcionario' => $funcionario])
            ->with('status', 'Dependente excluído com sucesso!');
    }
}
