<?php

namespace App\Http\Controllers\Admin\Funcionario;

use App\Enums\MotivoExclusaoConvenioEnum;
use App\Http\Controllers\Controller;
use App\Models\Convenio;
use App\Models\ConvenioPessoa;
use App\Models\Funcionario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ConvenioFuncionarioController extends Controller
{
    public function index(Funcionario $funcionario)
    {
        return view('admin.funcionarios.convenios.index', [
            'funcionario' => $funcionario,
            'convenios' => $funcionario->convenios
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Funcionario $funcionario)
    {
        $conveniosFuncionario = $funcionario->convenios->pluck('convenio_id');
        $convenios = Convenio::whereNotIn('id', $conveniosFuncionario)->orderBy('nome')->get();

        return view('admin.funcionarios.convenios.create', [
            'funcionario' => $funcionario,
            'convenios' => $convenios
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Funcionario $funcionario)
    {
        $convenio = new ConvenioPessoa($request->all());
        $funcionario->convenios()->save($convenio);

        return redirect()
            ->route('admin.funcionarios.convenios.index', ['funcionario' => $funcionario])
            ->with('status', 'Convênio incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function edit(Funcionario $funcionario, ConvenioPessoa $convenio)
    {
        $conveniosFuncionario = $funcionario->convenios->where('convenio_id', '!=', $convenio->convenio->id)->pluck('convenio_id');
        $convenios = Convenio::whereNotIn('id', $conveniosFuncionario)->orderBy('nome')->get();

        return view('admin.funcionarios.convenios.edit', [
            'funcionario' => $funcionario,
            'convenios' => $convenios,
            'convenio' => $convenio,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Funcionario $funcionario, ConvenioPessoa $convenio)
    {
        $convenio->fill($request->all());
        $convenio->save();

        return redirect()
            ->route('admin.funcionarios.convenios.index', ['funcionario' => $funcionario])
            ->with('status', 'Convênio editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Convenio  $convenio
     * @return \Illuminate\Http\Response
     */
    public function destroy(Funcionario $funcionario, ConvenioPessoa $convenio)
    {
        $possuiTermos = $funcionario->convenios()->temOsanOuSeguro()->first();

        DB::beginTransaction();
        $convenio->motivo_exclusao = MotivoExclusaoConvenioEnum::outro();
        $convenio->save();
        $convenio->delete();
        DB::commit();
        
        $convenio->delete();

        $redirect = redirect()
            ->route('admin.funcionarios.convenios.index', ['funcionario' => $funcionario])
            ->with('status', 'Convênio excluído com sucesso!');

        if ($possuiTermos) {
            $redirect->with('termos-assinar', true);
        }

        return $redirect;
    }
}
