<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\FeriadoStoreRequest;
use App\Http\Requests\FeriadoUpdateRequest;
use App\Models\Feriado;

class FeriadoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:admin']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.feriados.index');
    }

    public function load()
    {
        $feriados = Feriado
            ::search(request('start'), request('end'))
            ->formatted()->get()->toArray();

        return response()->json($feriados);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.feriados.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(FeriadoStoreRequest $request)
    {
        $datas = explode(' - ', $request->data_inicio_fim);

        $feriado = new Feriado();
        $feriado->data_inicio = $datas[0];
        $feriado->data_fim = $datas[1];
        $feriado->titulo = $request->titulo;
        $feriado->save();

        return redirect()
            ->route('admin.feriados.index')
            ->with('status', 'Feriado incluído com sucesso!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Feriado  $feriado
     * @return \Illuminate\Http\Response
     */
    public function show(Feriado $feriado)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Feriado  $feriado
     * @return \Illuminate\Http\Response
     */
    public function edit(Feriado $feriado)
    {
        return view('admin.feriados.edit', ['feriado' => $feriado]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Feriado  $feriado
     * @return \Illuminate\Http\Response
     */
    public function update(FeriadoUpdateRequest $request, Feriado $feriado)
    {
        $datas = explode(' - ', $request->data_inicio_fim);

        $feriado->titulo = $request->titulo;
        $feriado->data_inicio = $datas[0];
        $feriado->data_fim = $datas[1];
        $feriado->save();

        return redirect()
            ->route('admin.feriados.index')
            ->with('status', 'Feriado editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Feriado  $feriado
     * @return \Illuminate\Http\Response
     */
    public function destroy(Feriado $feriado)
    {
        $feriado->delete();

        return redirect()
            ->route('admin.feriados.index')
            ->with('status', 'Feriado excluído com sucesso!');
    }
}
