<?php

namespace App\Http\Controllers\Admin;

use App\Enums\ColunasExportacaoCSVEnum;
use App\Enums\FiltroServidoresAtivosAposentadosEnum;
use App\Enums\SituacaoServidorBuscaEnum;
use App\Exports\ServidoresExport;
use App\Http\Controllers\Controller;
use App\Models\Servidor;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ExportacaoCSVController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.exportacao-csv.index', [
            'filtrosAtivosAposentados' => FiltroServidoresAtivosAposentadosEnum::getAll(),
            'filtrosSituacao' => SituacaoServidorBuscaEnum::getAll(),
            'colunas' => ColunasExportacaoCSVEnum::getAll(),
        ]);
    }

    public function exporta(Request $request)
    {
        $filtroAtivoAposentado = FiltroServidoresAtivosAposentadosEnum::make((int) $request->filtroAtivoAposentado);
        $filtroSituacao = SituacaoServidorBuscaEnum::make((int) $request->filtroSituacao);
        $colunas = collect($request->colunas)->map(function ($coluna) {
            return ColunasExportacaoCSVEnum::make((int) $coluna);
        });

        $servidores = Servidor::with(['registros.unidadeOrganizacional.contatos', 'enderecos', 'contatos']);

        if ($filtroAtivoAposentado->isAtivo()) {
            $servidores->comRegistroAtivo();
        } elseif ($filtroAtivoAposentado->isAposentado()) {
            $servidores->semRegistroAtivo();
        }
        
        $servidores = $servidores->comSituacao($filtroSituacao)->orderBy('nome');

        return Excel::download(new ServidoresExport($servidores, $colunas), 'servidores.csv');
    }
}
