<?php

namespace App\Http\Controllers\Admin;

use App\Enums\CategoriaConfiguracaoEnum;
use App\Http\Controllers\Controller;
use App\Http\Requests\ConfiguracaoStoreRequest;
use App\Http\Requests\ConfiguracaoUpdateRequest;
use App\Models\Configuracao;
use Illuminate\Http\Request;

class ConfiguracaoController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:admin']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $configuracoes = Configuracao::all();
        return view('admin.configuracoes.index', ['configuracoes' => $configuracoes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categorias = CategoriaConfiguracaoEnum::getAll();
        return view('admin.configuracoes.create', ['categorias' => $categorias]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ConfiguracaoStoreRequest $request)
    {
        $configuracao = new Configuracao($request->all());
        $configuracao->categoria = CategoriaConfiguracaoEnum::make($request->categoria);
        $configuracao->save();


        return redirect()
            ->route('admin.configuracoes.index')
            ->with('status', 'Configuração incluída com sucesso!');
    }

    public function edit(Configuracao $configuracao)
    {
        $categorias = CategoriaConfiguracaoEnum::getAll();
        return view('admin.configuracoes.edit', ['configuracao' => $configuracao, 'categorias' => $categorias]);
    }

    public function update(ConfiguracaoUpdateRequest $request, Configuracao $configuracao)
    {
        $configuracao->fill($request->all());
        $configuracao->save();

        return redirect()
            ->route('admin.configuracoes.index')
            ->with('status', 'Configuração editada com sucesso!');
    }

    public function destroy(Configuracao $configuracao)
    {
        $configuracao->delete();

        return redirect()
            ->route('admin.configuracoes.index')
            ->with('status', 'Configuração excluída com sucesso!');
    }
}
