<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ClassificacaoContaStoreRequest;
use App\Http\Requests\ClassificacaoContaUpdateRequest;
use App\Models\ClassificacaoConta;
use App\Models\PlanoConta;

class ClassificacaoContaController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:admin']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(PlanoConta $plano)
    {
        $classificacoes = $plano->classificacoes;

        return view('admin.planos-contas.classificacoes.index', ['classificacoes' => $classificacoes, 'plano' => $plano]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(PlanoConta $plano)
    {
        return view('admin.planos-contas.classificacoes.create', ['plano' => $plano]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PlanoConta $plano, ClassificacaoContaStoreRequest $request)
    {
        $classificacao = new ClassificacaoConta($request->all());
        $plano->classificacoes()->save($classificacao);

        return redirect()
                ->route('admin.planos-contas.classificacoes.index', ['plano' => $plano])
                ->with('status', 'Plano de conta incluído com sucesso!');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ClassificacaoConta  $classificacao
     * @return \Illuminate\Http\Response
     */
    public function edit(PlanoConta $plano, ClassificacaoConta $classificacao)
    {
        return view('admin.planos-contas.classificacoes.edit', ['classificacao' => $classificacao, 'plano' => $plano]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PlanoConta  $plano
     * @param  \App\Models\ClassificacaoConta  $classificacao
     * @return \Illuminate\Http\Response
     */
    public function update(ClassificacaoContaUpdateRequest $request, PlanoConta $plano, ClassificacaoConta $classificacao)
    {
        $classificacao->fill($request->all());
        $classificacao->save();

        return redirect()
            ->route('admin.planos-contas.classificacoes.index', ['plano' => $plano])
            ->with('status', 'Plano de conta editado com sucesso!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PlanoConta  $plano
     * @return \Illuminate\Http\Response
     */
    public function destroy(PlanoConta $plano, ClassificacaoConta $classificacao)
    {
        $classificacao->delete();

        return redirect()
            ->route('admin.planos-contas.classificacoes.index', ['plano' => $plano])
            ->with('status', 'Plano de conta excluído com sucesso!');
    }
}
