<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Audit;
use Illuminate\Http\Request;

class AuditoriaController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:admin']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $intervalo = $request->intervalo;
        $evento = $request->evento;

        $logs = Audit::search($intervalo, $evento);
        return view('admin.auditoria.index', ['logs' => $logs, 'intervalo' => $intervalo, 'evento' => $evento]);
    }

    /*
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $log = Audit::find($id);
        return view('admin.auditoria.show', ['log' => $log]);
    }
}
