<?php

namespace App\Exceptions;

use App\Enums\CategoriaConfiguracaoEnum;
use App\Models\AgendamentoAtendimento;
use App\Models\Configuracao;

class UltimoAtendimentoMuitoProximoException extends ValidationException
{
    private $tipoAgendamento;

    public function __construct(string $nomePessoa, AgendamentoAtendimento $agendamento)
    {
        $this->tipoAgendamento = $agendamento->tipo;
        $this->message = "Não é possível fazer o agendamento pois o último agendamento de {$nomePessoa} foi a menos de {$this->quantidadeDias()} dias";
        $this->code = 0;
    }

    public function quantidadeDias()
    {
        $CONFIGURACAO = 'DIAS_ENTRE_AGENDAMENTOS';
        if ($this->tipoAgendamento->isJuridico()) {
            return intval(Configuracao::get($CONFIGURACAO, CategoriaConfiguracaoEnum::agendamentoJuridico()));
        } else {
            return intval(Configuracao::get($CONFIGURACAO, CategoriaConfiguracaoEnum::agendamentoOdontologico()));
        }
    }
}
