<?php

namespace App\Exceptions;

use App\Models\AgendamentoAtendimento;
use Carbon\Carbon;

class HorarioIndisponivelSobrepoeHorarioOdontologicoException extends ValidationException
{
    public function __construct(Carbon $inicio, Carbon $fim, AgendamentoAtendimento $agendamento)
    {
        $nomePessoa = $agendamento->agendavel->nome;
        
        $horario = "{$agendamento->inicio->format('H:i')} às {$agendamento->fim->format('H:i')}";
        $this->message = "O horário das {$inicio->format('H:i')} às {$fim->format('H:i')} de {$inicio->format('d/m/Y')} está indisponível para agendamento por já existir um agendamento para {$nomePessoa}, prestador {$agendamento->prestadorServico->nome} no horário das {$horario}";
        $this->code = 0;
    }
}
