<?php

namespace App\Exceptions;

use App\Models\AgendamentoAtendimento;
use Carbon\Carbon;

class HorarioIndisponivelSobrepoeHorarioJuridicoException extends ValidationException
{
    public function __construct(Carbon $inicio, Carbon $fim, AgendamentoAtendimento $agendamento)
    {
        $nomePessoa = $agendamento->agendavel->nome;
        
        $horario = "{$agendamento->inicio->format('H:i')} às {$agendamento->fim->format('H:i')}";
        $this->message = "O horário das {$inicio->format('H:i')} às {$fim->format('H:i')} de {$inicio->format('d/m/Y')} está indisponível para agendamento por já existir um agendamento para {$nomePessoa}, no horário das {$horario}";
        $this->code = 0;
    }
}
