<?php

namespace App\Exceptions;

use Carbon\Carbon;

class HorarioIndisponivelForaHorarioServicoException extends ValidationException
{
    public function __construct(Carbon $inicio, Carbon $fim)
    {
        $this->message = "O horário das {$inicio->format('H:i')} às {$fim->format('H:i')} de {$inicio->format('d/m/Y')} está indisponível para agendamento por estar fora do horário do serviço";
        $this->code = 0;
    }
}
